/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.AbstractBorder;

class ThreeDimensionalBorder
extends AbstractBorder {
    private static final long serialVersionUID = 1L;
    private Color color;
    private static int thickness = 2;
    private int param = 8;
    private Insets insets = null;
    private BasicStroke stroke = null;
    private static int strokePad;
    private static RenderingHints hints;
    private static int shadowPad;

    ThreeDimensionalBorder(Color color, int transparency, int shadowWidth) {
        this.color = color;
        shadowPad = shadowWidth;
        this.stroke = new BasicStroke(thickness);
        strokePad = thickness / 2;
        hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int pad = this.param + strokePad;
        int bottomPad = pad + strokePad + shadowPad;
        int rightPad = pad + strokePad + shadowPad;
        this.insets = new Insets(pad, pad, bottomPad + shadowPad, rightPad);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        int bottomLine = height - thickness - shadowPad;
        RoundRectangle2D.Double bubble = new RoundRectangle2D.Double(0 + strokePad, 0 + strokePad, width - thickness - shadowPad - 1, bottomLine - 1, this.param, this.param);
        Area area = new Area(bubble);
        g2.setRenderingHints(hints);
        g2.setColor(this.color);
        g2.setStroke(this.stroke);
        g2.draw(area);
        Color shadow = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 128);
        g2.setRenderingHints(hints);
        g2.setColor(shadow);
        g2.fillRoundRect(3 + strokePad, 3 + strokePad, width - thickness - shadowPad, bottomLine, this.param, this.param);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.getBorderInsets(c);
    }

    public static int getThickness() {
        return thickness;
    }

    public static int getStrokePad() {
        return strokePad;
    }

    public static int getShadowPad() {
        return shadowPad;
    }

    public static RenderingHints getHints() {
        return hints;
    }

    static {
        shadowPad = 2;
    }
}

